import { ExternalLink } from '@yandex-infracloud-ui/libs';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import { TagsHint } from '../../../components/stage-levels/stage/hints';
import { EXTERNAL_LINKS } from '../../../models';

import Tooltip from '../Tooltip/Tooltip';

import './TooltipInfo.scss';

const b = block('tooltip-info');

const descriptions = {
   tags: TagsHint(),
   abcService: 'Quota for resources will be taken from a chosen ABC service',
   monitoringProject: 'Alerts for deploy units will be created in corresponding project',

   // region status

   xRay: (
      <>
         Security and vulnerability analysis of the stage.{' '}
         <ExternalLink href={EXTERNAL_LINKS.wiki.xRay}>Read more</ExternalLink>.
      </>
   ),

   logsFilter: (
      <>
         {'Search by keys: host, pod, box, workload, container_id, logger_name, message.'}
         <div className={b('p', { space: true })}>
            <div>
               <b>Include values:</b>
            </div>
         </div>
         <div className={b('p', { space: true })}>
            <div>key = value1, value2, value3;</div>
         </div>
         <div className={b('p', { space: true })}>
            <div>
               <b>Exclude values:</b>
            </div>
         </div>
         <div className={b('p', { space: true })}>
            <div>key != value1, value2;</div>
         </div>
         <div className={b('p', { space: true })}>
            <div>
               <b>Literal values:</b>
            </div>
         </div>
         <div className={b('p', { space: true })}>
            <div>
               key = {'"'}literal value with {'\\"'}double quotes{'\\"'}
               {'"'};
            </div>
            <div>
               key = {'"'}literal value with other punctuation characters (=,;!){'"'};
            </div>
         </div>
      </>
   ),

   // endregion

   approvalsMode: (
      <span>
         On(Required): all deploy tickets must be approved by stage approvers before commit
         <br />
         Off(Optional): deploy ticket may be committed to stage without approvals
      </span>
   ),

   approvalsCount: <span>Minimal number of approvals to be able to commit ticket</span>,

   approvalsPolicy: (
      <span>
         On(Mandatory): ticket must be approved by at least one mandatory approver and total approvals must be not less
         than total count of approvals
         <br />
         Off(Default): all approvals are equal
      </span>
   ),
};

export default class TooltipInfo extends React.Component {
   static propTypes = {
      text: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),
      note: PropTypes.string,
      children: PropTypes.node,
      directions: PropTypes.arrayOf(PropTypes.string),
   };

   render() {
      const { note, directions = [] } = this.props;

      if (descriptions[note]) {
         return (
            <Tooltip
               text={descriptions[note]}
               active={true}
               hasTail={true}
               clickable={true}
               directions={[...directions, 'right-center']}
            >
               <i className={`far fa-info-circle ${b('icon-info')}`} />
            </Tooltip>
         );
      }
      return null;
   }
}
