import { useTitle } from '@yandex-infracloud-ui/libs';
import PropTypes from 'prop-types';

/**
 * Компонент-обертка, для вызова хука useTitle из старых компонентов (на классах)
 *
 * Не использовать в новом коде!
 * В старых компонентах лучше всего будет оборачивать им весь вывод в `render()` методе
 *
 * @example
 * class MyComponent extends React.Component {
 *    render() {
 *       return (
 *          <WindowTitle title={'My super title'}>
 *             Content of the component...
 *          </WindowTitle>
 *       );
 *    }
 * }
 */
export function WindowTitle({ children, title }) {
   useTitle(title);

   return children;
}

WindowTitle.displayName = 'WindowTitle';

WindowTitle.propTypes = {
   title: PropTypes.string,
   children: PropTypes.node,
};
