import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { NotificationsContext } from '../../services/Notifications';

export default function withNotifications(WrappedComponent) {
   const componentName = WrappedComponent.displayName || WrappedComponent.name || 'Component';

   return class extends Component {
      static contextTypes = {
         notifications: PropTypes.object.isRequired,
      };

      static displayName = `withNotifications(${componentName})`;

      static contextType = NotificationsContext;

      render() {
         return <WrappedComponent {...this.props} notifications={this.context} />;
      }
   };
}
