import PropTypes from 'prop-types';
import React from 'react';

import './Icon.scss';

export default class Icon extends React.Component {
   static propTypes = {
      size: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
      className: PropTypes.string,
      style: PropTypes.object,
   };

   static defaultProps = {
      size: 24,
      style: {},
   };

   render() {
      const { style, className, children } = this.props;
      return (
         <span
            className={`svg-icon icon_svg icon_size_s button2__icon button2__icon_side_left${
               className ? ` ${className}` : ''
            }`}
            style={style}
         >
            {children}
         </span>
      );
   }
}
