import { color, number, withKnobs } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import React from 'react';

import * as icons from './index';

function wrapWithGrid(content, { size, step }) {
   const rulerColor = 'rgba(255, 255, 255, 0.4)';
   const rulerSize = 1;
   const containerStyle = {
      position: 'relative',
      width: size,
      height: size,
   };
   const gridStyle = {
      position: 'absolute',
      top: 0,
      left: 0,
      right: 0,
      bottom: 0,
      backgroundSize: `${step}px 100%, 100% ${step}px`,
      backgroundImage: [
         `linear-gradient(to right, ${rulerColor} ${rulerSize}px, transparent ${rulerSize}px, transparent)`,
         `linear-gradient(to bottom, ${rulerColor} ${rulerSize}px, transparent ${rulerSize}px, transparent)`,
      ].join(','),
      backgroundRepeat: 'repeat-x, repeat-y',
   };

   return (
      <div style={containerStyle}>
         {content}
         <div style={gridStyle} />
      </div>
   );
}

function prepareIconProps() {
   return {
      width: '100%',
      height: '100%',
      // viewBox: '0 0 8 6',
      // width: '8',
      // height: '6',
      fill: color('Color', '#000000'),
   };
}

const iconStories = storiesOf('old-code/Icons', module).addDecorator(withKnobs);

Object.keys(icons)
   .sort((keyA, keyB) => (keyA > keyB ? 1 : -1))
   .reduce(
      (stories, key) =>
         stories.add(key, () => {
            const Icon = icons[key];
            const gridContent = <Icon {...prepareIconProps()} />;
            const gridOptions = {
               size: number('Grid Size', 320),
               step: number('Grid Step', 20),
            };

            return wrapWithGrid(gridContent, gridOptions);
         }),
      iconStories,
   );
