import { Button } from '@yandex-cloud/uikit';
import { YCSelect } from '@yandex-data-ui/common';
import { capitalize, Hint } from '@yandex-infracloud-ui/libs';
import block from 'bem-cn-lite';
import React, { Component } from 'react';

import { TagsHint } from '../../../components/stage-levels/stage/hints';
import ColoredInput from '../../components/ColoredInput/ColoredInput';
import { Menu } from '../../components/icons';
import Icon from '../../components/icons/Icon/Icon';
import RadioButton from '../../components/RadioButton/RadioButton';

const b = block('page-main');

export class PageMainFilters extends Component {
   constructor(props) {
      super(props);
      this.state = props.filters;
   }

   shouldComponentUpdate(nextProps) {
      const newFilters = {};
      if (nextProps === this.props) {
         return true;
      }
      for (const filterName of Object.keys(nextProps.filters)) {
         if (nextProps.filters[filterName] !== this.props.filters[filterName]) {
            newFilters[filterName] = nextProps.filters[filterName];
         }
      }
      if (Object.keys(newFilters).length > 0) {
         this.setState(newFilters);
         return false;
      }
      return true;
   }

   render() {
      const { setFilters } = this.props;
      const { my, objectType, name } = this.state;
      const emptyFilters = {
         my: 'yes',
         project: '',
         stage: '',
         name: '',
         objectType: 'stage',
      };
      return (
         <div className={b('filters')}>
            <div className={b('filter', { type: 'my' })} data-test={'filter-projects-by-owner'}>
               <RadioButton
                  value={my}
                  items={[
                     { key: 'filter-my-key-yes', value: 'yes', text: 'My' },
                     { key: 'filter-my-key-no', value: 'no', text: 'All' },
                  ]}
                  onChange={event => {
                     this.setState({ my: event.target.value }, () =>
                        window.setTimeout(() => setFilters(this.state), 0),
                     );
                  }}
               />
            </div>
            <div>Search by</div>
            <div className={b('filter', { type: 'objectType' })} data-test={'filter-projects-by-type'}>
               <YCSelect
                  onUpdate={value => {
                     console.log('yc', value);
                     this.setState(
                        state => ({ objectType: value, [value]: state.name }),
                        () => window.setTimeout(() => setFilters(this.state), 0),
                     );
                  }}
                  items={[
                     { key: 'project', value: 'project', title: <>{'Project'}</> },
                     { key: 'stage', value: 'stage', title: <>{'Stage'}</> },
                  ]}
                  showSearch={false}
                  value={objectType}
               />
            </div>
            <div className={b('filter', { type: 'name' })} data-test={'filter-projects-by-name'}>
               <ColoredInput
                  text={name}
                  rules={{
                     object: [/^[a-zA-Z0-9-_]+/, b('highlight-object', { type: objectType })],
                     tag: [/#[\w-]+\b/i, b('highlight-object', { type: 'tag' })],
                  }}
                  placeholder={`${capitalize(objectType)} ID or/and #tag`}
                  onChange={value => this.setState({ name: value })}
                  onKeyUp={event => event.keyCode === 13 && setFilters(this.state)}
                  hasClear
                  autoFocus
                  className={b('search-input-control')}
                  iconLeft={
                     <Icon className={b('search-input-icon')} style={{ color: name ? '#000' : '#999' }}>
                        <Menu width={12} height={12} fill={'currentColor'} />
                     </Icon>
                  }
               />
               <Hint text={<TagsHint />} />
            </div>
            <div data-test={'filter-projects-search'}>
               <Button view={'action'} onClick={() => setFilters(this.state)}>
                  Search
               </Button>
            </div>
            <div data-test={'filter-projects-reset'}>
               <Button
                  view={'clear'}
                  onClick={() => {
                     this.setState(emptyFilters);
                     setFilters(emptyFilters);
                  }}
               >
                  Reset
               </Button>
            </div>
         </div>
      );
   }
}
