/* eslint-disable complexity, no-negated-condition */
export const parseQuery = query => {
   const parsedQuery = {};
   let key = '';
   let value = '';
   let include = '';
   // always start with a key!
   let isKey = true;
   let isValue = false;
   let isLiteralValue = false;
   let isLiteralValueClosed = false;
   let values = [];
   const errors = [];

   if (query && query.trim()) {
      for (let i = 0, l = query.length; i < l; i += 1) {
         // service character inside a literal querying
         if (isValue && isLiteralValue && !isLiteralValueClosed && ['=', ' ', '\n', ';', ',', '!'].includes(query[i])) {
            value += query[i];
            // start or an end of a literal querying value
         } else if (query[i] === '"' && query[i - 1] !== '\\') {
            if (isLiteralValueClosed) {
               return {
                  errors: [
                     'Search query is incorrect. ',
                     `Values error (${value}${query[i]}). `,
                     'Commas or double quotes are required. ',
                  ],
               };
            }
            if (isLiteralValue) {
               isValue = false;
               isLiteralValueClosed = true;
            } else {
               if (isValue && value.trim()) {
                  return {
                     errors: [
                        'Search query is incorrect. ',
                        `Values error (${value}${query[i]}). `,
                        'Commas or double quotes are required. ',
                     ],
                  };
               }
               isValue = true;
               isLiteralValue = true;
               isLiteralValueClosed = false;
            }
            // include value
         } else if (query[i] === '!' || query[i] === '=') {
            isKey = false;
            include += query[i];
            // guaranteed end of a value
         } else if (query[i] === ';') {
            key = key.trim();

            if (key) {
               if ((key.includes(' ') && !/^context\./.test(key)) || key.includes('\n')) {
                  return { errors: ['Search query is incorrect. ', `Key error (${key}). `] };
               }

               if (isLiteralValue || (!isLiteralValue && value.trim())) {
                  if (isLiteralValue && !isLiteralValueClosed) {
                     return {
                        errors: [
                           'Search query is incorrect. ',
                           `Values error (${value}). `,
                           'Commas or double quotes are required. ',
                        ],
                     };
                  }
                  if (!isLiteralValue && (value.trim().includes(' ') || value.trim().includes('\n'))) {
                     return {
                        errors: [
                           'Search query is incorrect. ',
                           `Values error (${value}). `,
                           'Commas or double quotes are required. ',
                        ],
                     };
                  }

                  values.push(isLiteralValue ? value.replace(/\\"/g, '"') : value.trim());
               } else {
                  return { errors: ['Search query is incorrect. ', 'Value error. '] };
               }

               if (include !== '=' && include !== '!=') {
                  return { errors: ['Search query is incorrect. ', `Syntax error: "${include}". `] };
               }

               parsedQuery[key] = {
                  values,
                  select_type: include === '=' ? 'INCLUDE' : 'EXCLUDE',
               };

               isKey = true;
               isValue = false;
               isLiteralValue = false;
               isLiteralValueClosed = false;

               key = '';
               include = '';
               value = '';
               values = [];
            } else {
               return { errors: ['Search query is incorrect. ', 'Keys are required and cannot be empty. '] };
            }
            // delimeter between values
         } else if (query[i] === ',') {
            key = key.trim();

            if (key) {
               if (key.includes(' ') || key.includes('\n')) {
                  return { errors: ['Search query is incorrect. ', `Key error (${key}). `] };
               }

               if (isLiteralValue || (!isLiteralValue && value.trim())) {
                  if (isLiteralValue && !isLiteralValueClosed) {
                     return {
                        errors: [
                           'Search query is incorrect. ',
                           `Values error (${value}). `,
                           'Commas or double quotes are required. ',
                        ],
                     };
                  }
                  if (!isLiteralValue && (value.trim().includes(' ') || value.trim().includes('\n'))) {
                     return {
                        errors: [
                           'Search query is incorrect. ',
                           `Values error (${value}). `,
                           'Commas or double quotes are required. ',
                        ],
                     };
                  }

                  values.push(isLiteralValue ? value.replace(/\\"/g, '"') : value.trim());
               } else {
                  return { errors: ['Search query is incorrect. ', 'Value error. '] };
               }
            } else {
               return { errors: ['Search query is incorrect. ', 'Keys are required and cannot be empty. '] };
            }
            value = '';
            isLiteralValue = false;
            isLiteralValueClosed = false;
            // value continuation
         } else if (isValue) {
            if (isLiteralValue && isLiteralValueClosed) {
               return {
                  errors: [
                     'Search query is incorrect. ',
                     `Values error ("${value}" ${query[i]}). `,
                     'Commas or double quotes are required. ',
                  ],
               };
            }

            value += query[i];
            // key continuation
         } else if (isKey) {
            key += query[i];
            // no key, no value - then start of a non literal value
         } else if (query[i] !== ' ' && query[i] !== '\n') {
            if (isLiteralValue && isLiteralValueClosed) {
               return {
                  errors: [
                     'Search query is incorrect. ',
                     `Values error ("${value}" ${query[i]}). `,
                     'Commas or double quotes are required. ',
                  ],
               };
            }

            isValue = true;
            isLiteralValue = false;
            isLiteralValueClosed = false;
            value += query[i];
         }
      }

      key = key.trim();

      if (key) {
         if (key.includes(' ') || key.includes('\n')) {
            return { errors: ['Search query is incorrect. ', `Key error (${key}). `] };
         }

         if (isLiteralValue || (!isLiteralValue && value.trim())) {
            if (isLiteralValue && !isLiteralValueClosed) {
               return {
                  errors: [
                     'Search query is incorrect. ',
                     `Values error (${value}). `,
                     'Commas or double quotes are required. ',
                  ],
               };
            }
            if (!isLiteralValue && (value.trim().includes(' ') || value.trim().includes('\n'))) {
               return {
                  errors: [
                     'Search query is incorrect. ',
                     `Values error (${value}). `,
                     'Commas or double quotes are required. ',
                  ],
               };
            }

            values.push(isLiteralValue ? value.replace(/\\"/g, '"') : value.trim());
         } else {
            return { errors: ['Search query is incorrect. ', `No value (${key}). `] };
         }

         if (include !== '=' && include !== '!=') {
            return { errors: ['Search query is incorrect. ', `Syntax error: "${include}". `] };
         }

         parsedQuery[key] = {
            values,
            select_type: include === '=' ? 'INCLUDE' : 'EXCLUDE',
         };
      } else if (value.trim() || include) {
         return { errors: ['Search query is incorrect. ', 'Keys are required and cannot be empty. '] };
      }
   }

   parsedQuery.errors = errors;

   return parsedQuery;
};
/* eslint-enable complexity, no-negated-condition */
