import PropTypes from 'prop-types';
import React from 'react';

import Constants from './constants';
import NotificationItem from './NotificationItem';

class NotificationContainer extends React.Component {
   componentDidMount() {
      // Fix position if width is overrided
      this._style = this.props.getStyles.container(this.props.position);

      if (
         this.props.getStyles.overrideWidth &&
         (this.props.position === Constants.positions.tc || this.props.position === Constants.positions.bc)
      ) {
         this._style.marginLeft = -(this.props.getStyles.overrideWidth / 2);
      }
   }

   render() {
      if ([Constants.positions.bl, Constants.positions.br, Constants.positions.bc].includes(this.props.position)) {
         this.props.notifications.reverse();
      }

      let notifications = this.props.notifications.map(notification => (
         <NotificationItem
            ref={'notification-' + notification.uid}
            key={notification.uid}
            notification={notification}
            getStyles={this.props.getStyles}
            onRemove={this.props.onRemove}
            noAnimation={this.props.noAnimation}
            allowHTML={this.props.allowHTML}
            children={this.props.children}
         />
      ));

      return (
         <div className={'notifications-' + this.props.position} style={this._style}>
            {notifications}
         </div>
      );
   }
}

NotificationContainer.propTypes = {
   position: PropTypes.string.isRequired,
   notifications: PropTypes.array.isRequired,
   getStyles: PropTypes.object,
};

export default NotificationContainer;
