import * as pathToRegexp from 'path-to-regexp';

const routes = {
   pageMain: '/',
   stageCreate: '/create-stage',
   stage: '/stage/:stageId',
   stageStatus: '/stage/:stageId/status/:deployUnitId/:clusterId',
   project: '/projects/:projectId',
   pod: '/pod/:podId',
   balancers: '/balancers',
   namespaceInfo: '/balancers/:namespaceId',
   balancerCreate: '/balancers/create/:stageId',
   stageBalancers: '/stage/:projectId/stage-balancers',
   balancerEdit: '/stage/:projectId/balancers/:namespaceId',
   stageErrors: '/stage/:projectId/errors',
   stageConfig: '/stage/:projectId/config',
   stageLogs: '/stage/:projectId/logs',
   stageMonitoring: '/stage/:projectId/monitoring',
   projectReleases: '/stage/:projectId/releases',
   stageApprovalPolicy: '/stage/:stageId/approval-policy',
   stageJSON: '/stage/:projectId/json',

   stageHistory: '/stages/:stageId/history',
   stageHistoryRevision: '/stages/:stageId/history/:revisionId',
   stageHistoryRevisionEdit: '/stages/:stageId/history/:revisionId/edit',
   stageHistoryRevisionDeploy: '/stage/:projectId/history/:revisionId/deploy',
   stageHistoryRevisionDiff: '/stages/:stageId/history/:revisionId/diff/:revisionIdCompared',
};

export function createHref(route, params, options) {
   return pathToRegexp.compile(route)(params, options);
}

export default routes;
