import React from 'react';

let nextID = 1;

class Notifications {
   static DEFAULTS = {
      position: 'br',
      dismissible: false,
   };

   constructor() {
      this.listeners = {};
      this.notificationsData = {};
   }

   start(listeners = {}) {
      this.listeners = { ...listeners };
   }

   add(data) {
      if (!this.listeners.add) {
         throw new Error('Missing `add` listener.');
      }

      const uid = nextID;
      nextID += 1;

      this.notificationsData[uid] = data;

      return this.listeners.add({
         ...Notifications.DEFAULTS,
         ...data,
         uid,
      });
   }

   edit(uid, data) {
      if (!this.listeners.edit) {
         throw new Error('Missing `edit` listener.');
      }

      const prevData = this.notificationsData[uid] || {};
      const nextData = {
         ...prevData,
         ...data,
      };

      return this.listeners.edit(uid, {
         ...Notifications.DEFAULTS,
         ...nextData,
         uid,
      });
   }

   remove(uid) {
      if (!this.listeners.remove) {
         throw new Error('Missing `remove` listener.');
      }

      delete this.notificationsData[uid];
      this.listeners.remove(uid);
   }

   stop() {
      this.listeners = {};
      this.notificationsData = {};
   }
}

export const NotificationsContext = React.createContext(new Notifications());

export default Notifications;
