function generateUuid() {
   const random = () => Math.round(Math.random() * Math.pow(2, 32)).toString(16);

   return [random(), random(), random(), random()].join('-');
}

function headers() {
   return {
      'X-YT-Request-Format-Options': '{encode_utf8=%false}',
      'X-YT-Response-Format-Options': '{encode_utf8=%false}',
      'X-YT-Request-Id': generateUuid(),
   };
}

function onError(axiosError) {
   try {
      const ytRequestId = axiosError.config.headers['X-YT-Request-Id'];
      const ytError = JSON.parse(axiosError.response.headers['x-yt-error']);
      axiosError.response.data = { ytError: { request_id: ytRequestId, ...ytError } };
   } catch (e) {
      // ¯\_(ツ)_/¯
   }
}

export default {
   ListPods: {
      method: 'POST',
      path: '/ObjectService/SelectObjects',
      credentials: true,
      headers,
      onError,
   },
   CreateObject: {
      method: 'POST',
      path: '/ObjectService/CreateObject',
      credentials: true,
      headers,
      onError,
   },
   CreateObjects: {
      method: 'POST',
      path: '/ObjectService/CreateObjects',
      credentials: true,
      headers,
      onError,
   },
   UpdateObject: {
      method: 'POST',
      path: '/ObjectService/UpdateObject',
      credentials: true,
      headers,
      onError,
   },
   RemoveObject: {
      method: 'POST',
      path: '/ObjectService/RemoveObject',
      credentials: true,
      headers,
      onError,
   },
   SelectObjectHistory: {
      method: 'POST',
      path: '/ObjectService/SelectObjectHistory',
      credentials: true,
      headers,
      onError,
   },
   SelectObjects: {
      method: 'POST',
      path: '/ObjectService/SelectObjects',
      credentials: true,
      headers,
      onError,
   },
   GetObjects: {
      method: 'POST',
      path: '/ObjectService/GetObjects',
      credentials: true,
      headers,
      onError,
   },
   GetUserAccessAllowedTo: {
      method: 'POST',
      path: '/ObjectService/GetUserAccessAllowedTo',
      credentials: true,
      headers,
      onError,
   },
   CheckObjectPermissions: {
      method: 'POST',
      path: '/ObjectService/CheckObjectPermissions',
      credentials: true,
      headers,
      onError,
   },
};
