export default {
   get(key) {
      const value = localStorage.getItem(key);
      let result;

      if (!value) {
         return null;
      }

      try {
         result = JSON.parse(value);
      } catch (e) {
         result = null;
      }

      return result;
   },

   set(key, value) {
      const content = JSON.stringify(value);

      return localStorage.setItem(key, content);
   },

   remove(key) {
      return localStorage.removeItem(key);
   },

   clear() {
      return localStorage.clear();
   },
};
