import api from '../../services/api';
import { createApiActionTypes } from '../utils/api';

const FETCH_ABC_GROUP = createApiActionTypes('abc', 'FETCH_ABC_GROUP');
const FETCH_TVM_APP_LIST = createApiActionTypes('abc', 'FETCH_TVM_APP_LIST');

const getService = service => {
   // eslint-disable-next-line no-underscore-dangle
   service._id = service.id;
   service.name = service.name.ru ? service.name.ru : service.name;
   return service;
};

const getApps = apps =>
   apps.results
      .sort((a, b) => a.resource.external_id - b.resource.external_id)
      .map(result => ({
         id: Number(result.resource.external_id),
         alias: result.resource.name,
      }));

/* --- ACTIONS --- */
export function fetchAbcService({ params }) {
   const { serviceId } = params;

   return function fetchAbcServiceThunk(dispatch) {
      return api
         .request({
            service: 'abc',
            action: 'Service',
            params: {
               serviceId,
            },
         })
         .then(payload => {
            dispatch({
               type: FETCH_ABC_GROUP.SUCCESS,
               payload,
               serviceId,
            });
         });
   };
}

export function fetchTvmApps({ params }) {
   const { serviceId } = params;

   return function fetchTvmAppsThunk(dispatch) {
      return api
         .request({
            service: 'abc',
            action: 'ListTvmApps',
            query: {
               type: 47,
               state: 'granted',
               service: serviceId,
               page_size: 1000,
            },
         })
         .then(payload => {
            dispatch({
               type: FETCH_TVM_APP_LIST.SUCCESS,
               payload,
               serviceId,
            });
         });
   };
}

/* --- REDUCER --- */
const initialState = {
   services: {},
   tvmApps: {},
};

export default function staff(state = initialState, action) {
   switch (action.type) {
      case FETCH_ABC_GROUP.SUCCESS: {
         return {
            ...state,
            services: {
               ...state.services,
               [action.serviceId]: getService(action.payload),
            },
         };
      }
      case FETCH_TVM_APP_LIST.SUCCESS: {
         return {
            ...state,
            tvmApps: {
               ...state.tvmApps,
               [action.serviceId]: getApps(action.payload),
            },
         };
      }
      default:
         return state;
   }
}

export const getAbcServices = state => state.abc.services;

export const getAbcService = (state, id) => state.abc.services[id];

export const getTvmApps = state => state.abc.tvmApps;
