import api from '../../services/api';
import { createApiActionTypes } from '../utils/api';

/* --- ACTIONS --- */
const GET_PROJECT_ACL = createApiActionTypes('deploy-auth', 'GET_PROJECT_ACL');

export function getProjectAcl({ params }) {
   const { projectId } = params;

   return function getProjectAclThunk(dispatch) {
      return api
         .request({
            service: 'deploy_auth',
            action: 'GetProjectAcl',
            query: {
               project_id: projectId,
            },
         })
         .then(payload => {
            dispatch({
               type: GET_PROJECT_ACL.SUCCESS,
               payload,
               projectId,
            });
         });
   };
}

/* --- REDUCER --- */
const initialState = {
   projects: {},
};

export default function deployAuth(state = initialState, action) {
   switch (action.type) {
      case GET_PROJECT_ACL.SUCCESS: {
         const { payload, projectId } = action;
         const { projects } = state;
         projects[projectId] = payload;
         return {
            ...state,
            projects,
         };
      }
      default:
         return state;
   }
}

export const selectProjectsAcl = state => state.deployAuth.projects;
