import api from '../../services/api';
import { createApiActionTypes } from '../utils/api';

/* --- ACTIONS --- */
const FETCH_USERS = createApiActionTypes('staff', 'FETCH_USERS');
const FETCH_GROUPS = createApiActionTypes('staff', 'FETCH_GROUPS');

export function fetchPeople({ params }) {
   const { logins } = params;
   return function fetchPeopleThunk(dispatch) {
      api.request({
         service: 'staff',
         action: 'Persons',
         query: {
            _query: `login in ${JSON.stringify(logins)}`,
         },
      }).then(payload => {
         dispatch({
            type: FETCH_USERS.SUCCESS,
            payload,
            logins,
         });
      });
   };
}

export function fetchGroups({ params }) {
   const { groupIds } = params;

   return function fetchGroupsThunk(dispatch) {
      groupIds.forEach(groupId => +groupId);
      api.request({
         service: 'staff',
         action: 'Groups',
         query: {
            _query: `id in ${JSON.stringify(groupIds.map(groupId => +groupId))}`,
         },
      }).then(payload => {
         dispatch({
            type: FETCH_GROUPS.SUCCESS,
            payload,
            groupIds,
         });
      });
   };
}

/* --- REDUCER --- */
const initialState = {
   people: [],
   peopleFetched: [],
   groups: [],
   groupsFetched: [],
};

export default function staff(state = initialState, action) {
   switch (action.type) {
      case FETCH_USERS.SUCCESS: {
         return {
            ...state,
            peopleFetched: state.peopleFetched.concat(action.logins),
            people: state.people.concat(action.payload.result),
         };
      }
      case FETCH_USERS.FAILURE: {
         return state;
      }
      case FETCH_GROUPS.SUCCESS: {
         return {
            ...state,
            groupsFetched: state.groupsFetched.concat(action.groupIds),
            groups: state.groups.concat(action.payload.result),
         };
      }
      case FETCH_GROUPS.FAILURE: {
         return state;
      }
      default:
         return state;
   }
}

export const selectPeople = state =>
   state.staff.people.reduce((acc, person) => {
      acc[person.login] = person;

      return acc;
   }, {});

export const selectFetchedPeople = state => state.staff.peopleFetched;

export const selectGroups = state =>
   state.staff.groups.reduce((acc, group) => {
      acc[group.id] = group;

      return acc;
   }, {});

export const selectFetchedGroups = state => state.staff.groupsFetched;
