import { parseError } from '../../utils/common';

export function createApiActionTypes(prefix, type) {
   return {
      REQUEST: `${prefix}/${type}_REQUEST`,
      SUCCESS: `${prefix}/${type}_SUCCESS`,
      FAILURE: `${prefix}/${type}_FAILURE`,
   };
}

export function dispatchApiRequest(dispatch, { request, actionType, errorType, config, options }) {
   if (options && !options.silent) {
      dispatch({ type: actionType.REQUEST });
   }

   return request(config)
      .then(payload => {
         dispatch({ type: actionType.SUCCESS, payload });
      })
      .catch(error => {
         const payload = parseError(error, errorType);

         dispatch({ type: actionType.FAILURE, payload });

         throw error;
      });
}
