export function isModifiedEvent(event) {
   return Boolean(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
}

function getErrorTitle(error, type) {
   switch (type) {
      case 'compute':
      case 'users': {
         return error.code || error.type;
      }
      case 'mdb':
      case 'storage':
      case 'billing': {
         // TODO
         return '';
      }
      default: {
         throw new Error(`Unknown error type: \`${type}\``);
      }
   }
}

function getErrorDescription(error, type) {
   switch (type) {
      case 'compute':
      case 'users': {
         return error.details || error.message;
      }
      case 'billing':
      case 'mdb': {
         return typeof error.error === 'string' ? error.error : '';
      }
      case 'storage': {
         return error.detail;
      }
      default: {
         throw new Error(`Unknown error type: \`${type}\``);
      }
   }
}

export function parseError(error, type = 'compute') {
   let status;
   let title;
   let description;

   if (error.response) {
      const responseData = error.response.data;
      const statusTitle = `${error.response.status} ${error.response.statusText}`;
      const errorTitle = getErrorTitle(responseData, type);

      status = error.response.status;
      title = errorTitle ? `${statusTitle}: ${errorTitle}` : statusTitle;
      description = getErrorDescription(responseData, type);
   } else {
      status = 500;
      title = 'Ошибка';
      description = error.message;
   }

   return { status, title, description };
}
