import { isEmpty } from '@yandex-infracloud-ui/libs';

const SEPARATOR_REGEXP = /[\s,;+]+/;
const TAG_REGEXP = /^#/;

export interface ParsedQuery {
   names: string[];
   tags: string[];
}

/**
 * Парсинг запроса, вычленение тегов
 *
 * Код портирован из Walle, сильно урезан
 */
export function parseQueryWithTags(query: string): ParsedQuery {
   return query
      .trim()
      .split(SEPARATOR_REGEXP)
      .reduce(
         (acc, part) => {
            if (TAG_REGEXP.test(part)) {
               if (part !== '#') {
                  acc.tags.push(part.replace(/^#/, ''));
               }
            } else if (!isEmpty(part)) {
               acc.names.push(part);
            }

            return acc;
         },
         {
            names: [],
            tags: [],
         } as ParsedQuery,
      );
}

export function isMatched(query: ParsedQuery | string, entityName: string, entityTags: string[] | null): boolean {
   const parsedQuery = typeof query === 'string' ? parseQueryWithTags(query) : query;

   const queryName = parsedQuery.names.join('');
   const nameMatched = queryName ? entityName.includes(queryName) : true;
   const tagsMatched = entityTags ? parsedQuery.tags.every(tag => entityTags.includes(tag)) : true;

   return nameMatched && tagsMatched;
}
