import React from 'react';
import { generatePath, Redirect, Route, Switch } from 'react-router';

function stageRedirect(path: string, exact = true, newPath?: string, prefixes = ['/stage', '/project']) {
   const rest = exact ? '' : '/*';

   return (
      <Route
         path={prefixes.map(p => `${p}/:stageId${path}${rest}`)}
         exact={exact}
         render={({ location, match }) => (
            <Redirect
               to={{
                  ...location,
                  pathname: generatePath(`/stages/:stageId${newPath ?? path}${rest}`, match.params as any),
               }}
            />
         )}
      />
   );
}

const newStageRedirect = (path: string, exact = true, newPath?: string) =>
   stageRedirect(path, exact, newPath, ['/stages']);

export const OldRouteRedirects: React.FC = React.memo(() => (
   <Switch>
      <Redirect from={'/create-stage'} to={'/new-stage'} />
      {stageRedirect('')}
      {stageRedirect('/status/:duId/:clusterId')}
      {newStageRedirect('/du-:duId', false, '/config/du-:duId')}
      {newStageRedirect('/stage-:stageId2', true, '/config')} {/* index */}
      {newStageRedirect('/stage-:stageId2', false, '/config')}
      {stageRedirect('/config', true)} {/* index */}
      {stageRedirect('/config', false)}
      {stageRedirect('/logs')}
      {stageRedirect('/monitoring')}
      {stageRedirect('/history/:rId/edit/stage-:stageId2', true, '/history/:rId/edit')} {/* index */}
      {stageRedirect('/history/:rId/edit/stage-:stageId2', false, '/history/:rId/edit')}
      {stageRedirect('/history', true)} {/* index */}
      {stageRedirect('/history', false)}
      {stageRedirect('/releases', true, '/deploy-tickets')} {/* index */}
      {stageRedirect('/releases', false, '/deploy-tickets')}
      {stageRedirect('/release_rules', false)}
      {stageRedirect('/balancers')}
   </Switch>
));

OldRouteRedirects.displayName = 'OldRouteRedirects';
