import { AppRouteProps } from '../models';
import BalancerCreatePage from '../old-code/containers/BalancerCreatePage/BalancerCreatePage';
import Balancers from '../old-code/containers/Balancers/Balancers';
import NamespaceInfoPage from '../old-code/containers/NamespaceInfoPage/NamespaceInfoPage';
import PageMain from '../old-code/containers/PageMain/PageMain';
import Project from '../old-code/containers/Project/Project';
import { AboutPage } from './about';
import { AdminPage } from './admin';
import { NamespaceMapPage } from './balancers/_namespaceId/map';
import { ChangelogPage } from './changelog';
import { JsException } from './js-exception';
import { NewStagePage } from './new-stage/NewStagePage';
import { OldRoutesPage } from './old-routes';
import { Quotas } from './quotas/Quotas';
import { ReleaseIndexPage } from './releases/_releaseId';
import { StageIndexPage } from './stages/_stageId';
import { YpIndexPage } from './yp';

export const ROUTES: AppRouteProps[] = [
   { path: '/about', component: AboutPage },
   { path: '/admin', component: AdminPage },
   { path: '/balancers/create/:stageId', component: BalancerCreatePage },
   { path: '/balancers/:namespaceId/map', component: NamespaceMapPage },
   { path: '/balancers/:namespaceId', component: NamespaceInfoPage },
   { path: '/balancers', component: Balancers, exact: true },
   { path: '/changelog', component: ChangelogPage },
   { path: '/js-exception', component: JsException },
   { path: '/new-stage', component: NewStagePage },
   { path: '/old-routes', component: OldRoutesPage },
   { path: '/projects/:projectId', component: Project },
   { path: '/stages/:stageId', component: StageIndexPage },
   { path: '/releases/:releaseId', component: ReleaseIndexPage },
   { path: '/yp', component: YpIndexPage },
   { path: '/quotas', component: Quotas },
   { path: '/', component: PageMain, exact: true },
];
