import { formatDate, Json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { Link } from 'react-router-dom';

import { Page } from '../../components/layout/Page/Page';
import { urlBuilder } from '../../models';
import { Config, useConfig } from '../../services';

import styles from './index.module.css';

export const AboutPage = () => {
   const config = useConfig()!;

   return (
      <Page title={'About'} header={<h1>About</h1>}>
         <table className={styles.table}>
            <tbody>
               <tr>
                  <td>Build version</td>
                  <td>
                     {config.version} <Link to={urlBuilder.changelog()}>Open changelog</Link>
                  </td>
               </tr>
               <tr>
                  <td>Build date</td>
                  <td>{config.now ? formatDate(config.now, 'yyyy-MM-dd HH:mm') : null}</td>
               </tr>
               <tr>
                  <td>
                     <code>CONFIG_PRESET</code>
                  </td>
                  <td>{config.rawConfig.envName}</td>
               </tr>
               <tr>
                  <td>
                     <code>window.CONFIG</code>
                  </td>
                  <td>
                     <Json obj={config.rawConfig} />
                  </td>
               </tr>
               <tr>
                  <td>
                     <code>window.USER</code>
                  </td>
                  <td>
                     <Json obj={config.user} />
                  </td>
               </tr>
               <tr>
                  <td>Raw environment</td>
                  <td>
                     <Json obj={Config.getEnvVariables()} />
                  </td>
               </tr>
            </tbody>
         </table>
      </Page>
   );
};

AboutPage.displayName = 'AboutPage';
