import React from 'react';

import { urlBuilder } from '../../../models';
import NavigationTabs from '../../../old-code/components/NavigationTabs/NavigationTabs';
import { SidecarType } from '../../../services/api/services/InfracomponentsApi';

interface NavigationTab {
   path: string | { url: string; match: { predicate: string; strict?: boolean }[] };
   id: string;
   title: string;
}

const tabs: NavigationTab[] = [
   {
      path: urlBuilder.adminSummary(),
      id: 'summary',
      title: 'Config summary',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.Patchers),
      id: 'infraCompsPatchers',
      title: 'Patchers',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.PodAgentBin),
      id: 'infraCompsPodAgent',
      title: 'PodAgent',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.TVM),
      id: 'infraCompsTVM',
      title: 'TVM',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.Logbroker),
      id: 'infraCompsPatchersLogbroker',
      title: 'Logbroker',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.DRU),
      id: 'infraCompsPatchersDRU',
      title: 'DRU',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.Xenial),
      id: 'baseLayerXenial',
      title: 'Xenial',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.Bionic),
      id: 'baseLayerBionic',
      title: 'Bionic',
   },
   {
      path: urlBuilder.adminInfraComponentsSidecar(SidecarType.Focal),
      id: 'baseLayerFocal',
      title: 'Focal',
   },
];

export const AdminTabs: React.FC = React.memo(() => <NavigationTabs tabs={tabs} />);

AdminTabs.displayName = 'AdminTabs';
