import { SwitchRoutes } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { RouteComponentProps } from 'react-router';
import { ROUTES } from './_routes';
import { AdminTabs } from './AdminTabs/AdminTabs';
import styles from './index.module.css';

export const AdminPage: React.FC<RouteComponentProps> = React.memo(({ match }) => {
   const pageHeader = (
      <div>
         <h1 className={styles.header}>Deploy admin</h1>

         <div className={styles.tabs}>
            <AdminTabs />
         </div>
      </div>
   );

   return (
      <div className={styles.page}>
         {pageHeader}
         <div className={styles.content}>
            <SwitchRoutes>{ROUTES}</SwitchRoutes>
         </div>
      </div>
   );
});

AdminPage.displayName = 'AdminPage';
