import React, { ReactNode, useEffect, useMemo, useState } from 'react';

import { RouteComponentProps } from 'react-router';
import { Loader } from '@yandex-infracloud-ui/libs';
import { getNamespaceMap, NamespaceMapGraph, RawNamespaceItem } from '@yandex-infracloud-ui/awacs';
import '@yandex-infracloud-ui/awacs/dist/index.css';

import { awacsApi } from '../../../../services';
import { urlBuilder } from '../../../../models';
import { Breadcrumbs } from '../../../../old-code/components/Breadcrumbs/Breadcrumbs';

export const NamespaceMapPage: React.FC<RouteComponentProps<{ namespaceId: string }>> = React.memo(({ match }) => {
   const { namespaceId } = match.params;

   const [rawData, setRawData] = useState<null | RawNamespaceItem[]>(null);
   const [error, setError] = useState(null as any);

   useEffect(() => {
      awacsApi.GetNamespaceMap(namespaceId).subscribe(
         data => setRawData(data),
         apiError => {
            console.error(apiError);
            setError(apiError);
         },
      );
   }, [namespaceId]);

   const map = useMemo(() => (rawData ? getNamespaceMap(rawData, namespaceId) : null), [namespaceId, rawData]);
   useEffect(() => {
      console.log(map);
   }, [map]);

   let content: ReactNode = null;

   if (error !== null) {
      content = (
         <p>
            Error
            <pre>{String(error)}</pre>
         </p>
      );
   } else if (map === null) {
      content = <Loader />;
   } else {
      content = <NamespaceMapGraph namespaceMap={map} />;
   }

   return (
      <div style={{ padding: '30px' }}>
         <Breadcrumbs
            links={[
               { name: 'All namespaces', url: urlBuilder.balancers() },
               { name: namespaceId, url: urlBuilder.awacsNamespace(namespaceId) },
               { name: 'map' },
            ]}
         />
         {content}
      </div>
   );
});

NamespaceMapPage.displayName = 'NamespaceMapPage';
