import React, { useState } from 'react';

import { UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs';

import { StartrekTicket, StartrekRenderMode } from '../../components';

import classes from './TicketRow.module.scss';

interface Props {
   ticketId: string;
   ticketData: Record<string, Record<string, string[]>>;
}

export const TicketRow: React.FC<Props> = React.memo(({ ticketId, ticketData }) => {
   const [visible, setVisible] = useState(false);

   const authors = Object.keys(ticketData).sort();
   return (
      <div className={classes.row}>
         <div className={classes.header} onClick={() => setVisible(v => !v)} role={'link'} tabIndex={0}>
            <StartrekTicket mode={StartrekRenderMode.ROW} id={ticketId} className={classes.header} />
         </div>
         {visible && (
            <div className={classes.body}>
               {authors.map(author => {
                  const dates = ticketData[author];
                  return (
                     <div className={classes.authorRow} key={author}>
                        <div>
                           <UserName value={{ id: author, type: UserOrGroupType.People }} />
                        </div>
                        <div className={classes.dates}>
                           {Object.keys(dates).map((date, i) => {
                              const times = dates[date];
                              return (
                                 <span>
                                    {i > 0 ? ', ' : ''}
                                    {date} ({times.join(', ')})
                                 </span>
                              );
                           })}
                        </div>
                     </div>
                  );
               })}
            </div>
         )}
      </div>
   );
});

TicketRow.displayName = 'TicketRow';
