import React from 'react';
import { YpErrorTooltip } from '../../../../components/network';
import { useNetworkErrors } from '../../../../redux';

interface Props {
   requestKey: string;
   className: string;
}

export const PageMainCreateProjectError: React.FC<Props> = React.memo(({ requestKey, className }) => {
   const errors = useNetworkErrors([requestKey]);
   const error = errors[requestKey];

   return error ? (
      <div className={className}>
         <YpErrorTooltip error={error.error!} request={error.request} />
      </div>
   ) : null;
});

PageMainCreateProjectError.displayName = 'PageMainCreateProjectError';
