import React from 'react';
import { Link } from 'react-router-dom';

import { Page } from '../../components/layout/Page/Page';

interface RouteGroups {
   [groupName: string]: Record<string, string>;
}

const stageId = `khoden-deploy-ui-stage`;
const duId = 'Deploy_UI';

const links: RouteGroups = {
   'Stage status': {
      [`/stage/${stageId}`]: 'Simple stage',
      [`/project/${stageId}`]: 'Simple stage',
      [`/stage/${stageId}/status/${duId}/sas?page=1&per_page=10&status=ready&revision=any`]: 'DU & Cluster in status tab (must keep query params)',
      [`/project/${stageId}/status/${duId}/sas?page=1&per_page=10&status=ready&revision=any`]: 'DU & Cluster in status tab (must keep query params)',
   },
   'Stage config (form)': {
      [`/stages/${stageId}`]: 'Stage',
      [`/stages/${stageId}/du-${duId}/box-Docker`]: 'Stage form node (first version of form)',
      [`/stages/${stageId}/stage-${stageId}`]: 'Stage (full URL)',
      [`/stages/${stageId}/stage-${stageId}/du-${duId}`]: 'DeployUnit',
      [`/stages/${stageId}/stage-${stageId}/du-${duId}/box-Docker`]: 'Box',
      [`/stages/${stageId}/stage-${stageId}/du-${duId}/box-Docker/wl-supervisord`]: 'Workload',
   },
   'Stage history': {
      [`/stage/${stageId}/history`]: 'List',
      [`/stage/${stageId}/history/65/edit`]: 'Rollback form',
      [`/stage/${stageId}/history/65/edit/stage-${stageId}`]: 'Rollback form (Stage (full URL))',
      [`/stage/${stageId}/history/65/edit/stage-${stageId}/du-${duId}`]: 'Rollback form (DeployUnit)',
      [`/stage/${stageId}/history/65/edit/stage-${stageId}/du-${duId}/box-Docker`]: 'Rollback form (Box)',
      [`/stage/${stageId}/history/65/edit/stage-${stageId}/du-${duId}/box-Docker/wl-supervisord`]: 'Rollback form (Workload)',
      [`/stage/${stageId}/history/65/diff/66`]: 'Compare revisions',
      [`/stage/${stageId}/history/65`]: 'Revision',
   },
   'Stage release integration (deploy tickets, release rules)': {
      [`/stage/test-release-integration-stage/release_rules/new`]: 'New release rule',
      [`/stage/test-release-integration-stage/release_rules/test-alonger-rr`]: 'Release rule',
      [`/stage/test-release-integration-stage/releases/SANDBOX-808572930-stable-test-alonger-rr`]: 'Deploy ticket',
      [`/stage/test-release-integration-stage/releases`]: 'Deploy tickets',
   },
   'Stage other tabs': {
      [`/project/deploy-logs-validation/logs?deploy-unit=validation-deploy-unit&level=ERROR&limit=5`]: 'Logs (must keep query params)',
      [`/stage/deploy-logs-validation/logs?deploy-unit=validation-deploy-unit&level=ERROR&limit=5`]: 'Logs (must keep query params)',

      [`/project/${stageId}/monitoring`]: 'Monitoring',
      [`/stage/${stageId}/monitoring`]: 'Monitoring',

      [`/project/${stageId}/balancers`]: 'Balancers (list)',
      [`/stage/${stageId}/balancers`]: 'Balancers (list)',
   },
   'Other pages': {
      '/create-stage': 'New stage',
   },
};

export const OldRoutesPage: React.FC = React.memo(() => (
   <Page title={'Old routes support'} header={<h1>Old routes support</h1>}>
      {Object.keys(links).map(groupName => (
         <section key={groupName}>
            <h3>{groupName}</h3>
            <ul>
               {Object.keys(links[groupName]).map(url => (
                  <li key={url}>
                     <Link to={url}>{links[groupName][url]}</Link> <code>{url}</code>
                  </li>
               ))}
            </ul>
         </section>
      ))}
   </Page>
));

OldRoutesPage.displayName = 'OldRoutesPage';
