import { TIMES_IN_MS, UpdateTimerMode, useUpdateTimer } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useEffect } from 'react';
import { useDispatch } from 'react-redux';
import { RouteComponentProps } from 'react-router';
import Project from '../../../old-code/containers/Project/Project';
import { fetchInfraDoctorStat } from '../../../redux';

function useProjectProblemsStat(projectId: string) {
   const dispatch = useDispatch();

   const updateProblems = useCallback(() => {
      dispatch(fetchInfraDoctorStat({ object_type: 'yp.project', id: projectId }));
   }, [dispatch, projectId]);

   useEffect(() => {
      updateProblems();
   }, [updateProblems]);

   useUpdateTimer({
      callback: updateProblems,
      fast: TIMES_IN_MS.Minute,
      mode: UpdateTimerMode.Slow,
      slow: TIMES_IN_MS.Minute * 5,
   });
}

export const ProjectPage: React.FC<RouteComponentProps<{ projectId: string }>> = props => {
   useProjectProblemsStat(props.match.params.projectId);
   return <Project {...props} />;
};
