import { YCSelect } from '@yandex-data-ui/common';
import { classNames } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useState } from 'react';
import { QuotaOrder } from '../models';

import classes from './QuotaFilters.module.css';

export interface QuotaFiltersParams {
   order: QuotaOrder;
}

interface Props {
   filters: QuotaFiltersParams;
   className?: string;

   onFiltersChange(newFilters: QuotaFiltersParams): void;
}

const orderSelectorItems = [
   {
      title: QuotaOrder.Account,
      value: QuotaOrder.Account,
   },
   {
      title: QuotaOrder.Cluster,
      value: QuotaOrder.Cluster,
   },
];

export const QuotaFilters: React.FC<Props> = ({ onFiltersChange, filters, className }) => {
   const [quotaFilters, setFilters] = useState<QuotaFiltersParams>(filters);

   const onInputChange = useCallback(
      <T extends keyof Required<QuotaFiltersParams>>(fieldName: T, fieldValue: Required<QuotaFiltersParams[T]>) => {
         const newFiltersState = { ...quotaFilters, [fieldName]: fieldValue };
         setFilters(newFiltersState);
         onFiltersChange(newFiltersState);
      },
      [quotaFilters, onFiltersChange],
   );

   const onSelect = useCallback(
      (value: string) => {
         onInputChange('order', value as QuotaOrder);
      },
      [onInputChange],
   );

   return (
      <div className={classNames(classes.filters, className)}>
         <YCSelect
            label={'Ordering: '}
            type={YCSelect.SINGLE}
            items={orderSelectorItems}
            value={quotaFilters.order}
            showSearch={false}
            onUpdate={onSelect}
            className={classNames(classes.control, classes.order)}
            // disabled={disabled}
         />
         {/* <select
            onChange={e => {
               onInputChange('order', e.target.value as QuotaOrder);
            }}
         >
            {orderSelectorItems.map(item => (
               <option key={item.value} value={item.value}>
                  {item.title}
               </option>
            ))}
         </select> */}
      </div>
   );
};

QuotaFilters.displayName = 'QuotaFilters';
