import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { EXTERNAL_LINKS } from '../../../models';
import classes from './Account.module.css';

interface Props {
   id: string;
   name: string;
}

const numberRegex = /abc:service:([0-9]+)/;

export const Account: React.FC<Props> = ({ id, name }) => {
   const numMatch = id.match(numberRegex);
   let accountNumberId;
   if (numMatch) {
      accountNumberId = numMatch[1]; //eslint-disable-line
   }

   return (
      <span>
         {name}
         {accountNumberId ? (
            <ExternalLink className={classes.link} href={EXTERNAL_LINKS.abcService(accountNumberId)}>
               ABC
            </ExternalLink>
         ) : null}
      </span>
   );
};

Account.displayName = 'Quotas__Account';
