import { Button, Loader } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useMemo, useState } from 'react';

import { CollapsibleContainer } from '../../../components/common';
import { PodSetsResourcesTable } from '../../../components/yp';
// import { faChevronUp } from '@fortawesome/free-solid-svg-icons';
// import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { YpLocation } from '../../../models/api';
import { useYpAccountPodSets } from '../../../redux/hooks/useYpAccountPodSets';
import { AccountQuota } from '../__accountQuota/AccountQuota';
import { GraphNode } from '../models';

import classes from './TreeNode.module.css';

interface Props {
   node: GraphNode;
   className?: string;
}

export const TreeNode: React.FC<Props> = ({ node, className }) => {
   const { title, level, children, quota, key, value } = node;
   const { canLoadMore, podSets, isFetching, onLoadMore } = useYpAccountPodSets(
      value.accountId,
      value.cluster,
      value.segment,
   );

   const [isInited, setInited] = useState(false);
   const [isOpened] = useState(level === 1);

   const childrenContent = useMemo(() => {
      switch (level) {
         case 0:
            if (isInited) {
               return Object.values(children!).map((childNode: GraphNode) => (
                  <TreeNode key={childNode.key} node={childNode} />
               ));
            }
            return null;
         case 1:
            return Object.values(children!).map((childNode: GraphNode) => (
               <TreeNode key={childNode.key} node={childNode} />
            ));
         case 2:
            if (podSets?.length) {
               return (
                  <div>
                     <PodSetsResourcesTable podSets={podSets} cluster={value.cluster! as YpLocation} />
                     {canLoadMore ? (
                        <Button view={'outlined'} onClick={onLoadMore}>
                           Load more
                        </Button>
                     ) : null}
                     {/* <div className={classes.collapseContainer}>
                        <Button
                           view={'clear'}
                           onClick={e => {
                              setOpened(false);
                           }}
                        >
                           <FontAwesomeIcon className={classes.collapseIcon} icon={faChevronUp} />
                           Collapse
                        </Button>
                     </div> */}
                  </div>
               );
            }

            if (isFetching) {
               return (
                  <div className={classes.loaderContainer}>
                     <Loader size={'s'} />
                  </div>
               );
            }
      }

      return null;
   }, [children, level, isInited, podSets, isFetching, canLoadMore, value.cluster, onLoadMore]);

   const loadPodSetsIfNeed = useCallback(() => {
      if (!isOpened && !podSets?.length) {
         onLoadMore();
      }
   }, [isOpened, podSets, onLoadMore]);

   const subtitle = useMemo(
      () => (level === 2 ? <AccountQuota key={key} limit={quota?.limit} usage={quota?.usage} /> : null),
      [level, key, quota],
   );

   const onOpen = useCallback(
      (newOpenState: boolean) => {
         if (!isInited && newOpenState) {
            setInited(true);
         }

         if (level === 2 && newOpenState) {
            loadPodSetsIfNeed();
         }
      },
      [isInited, level, loadPodSetsIfNeed],
   );

   return (
      <CollapsibleContainer
         title={title}
         highlightTitle={level !== 2}
         showArrow={level === 0}
         isOpened={isOpened}
         className={classNames(classes.node, classes[`node-level-${level}`], className)}
         subtitle={subtitle}
         onOpen={onOpen}
         openOnTitleClick={level !== 2}
      >
         {childrenContent}
      </CollapsibleContainer>
   );
};

TreeNode.displayName = 'Quotas__TreeNode';
