import { ReactNode } from 'react';
import { YpLocation } from '../../models/api';
import { YpAccountQuota } from '../../models/ui';
import { TPerSegmentResourceTotals } from '../../proto-typings';

export enum QuotaOrder {
   'Account' = 'Account/Cluster/Segment',
   'Cluster' = 'Cluster/Account/Segment',
}

export type OrderingKey = Extract<keyof YpAccountQuota, 'accountId' | 'cluster' | 'segment'>;

export type ResourceType = keyof TPerSegmentResourceTotals;

export const orderingOptions: Record<QuotaOrder, OrderingKey[]> = {
   [QuotaOrder.Account]: ['accountId', 'cluster', 'segment'],
   [QuotaOrder.Cluster]: ['cluster', 'accountId', 'segment'],
};

export type GraphNodeValue = {
   accountId: string;
   cluster: YpLocation;
   segment: string;
};

export type GraphNode = {
   value: GraphNodeValue;
   title: ReactNode;
   key: string;
   level: number;
   quota?: {
      limit?: TPerSegmentResourceTotals;
      usage?: TPerSegmentResourceTotals;
   };
   children?: {
      [value: string]: GraphNode;
   };
};

export type GraphObject = {
   [value: string]: GraphNode;
};
