import { EmptyContainer, EmptyContainerType } from '@yandex-infracloud-ui/libs';
import React, { useMemo } from 'react';

import { DeployTicketFilters } from '../../../../../models/ui';
import { SelectDeployTicketOptions } from '../../../../../redux';
import { DeployTicketsBlock } from '../../../../../components/deployTicket';
import { GetDeployTicketsReqOptions } from '../../../../../services/api/services/YpApi';
import { Column, DeployTicketPageType } from '../../../../../components/deployTicket/model';

const excludeColumns: Set<Column> = new Set(['release', 'releaseRule']);
interface Props {
   releaseId: string;
}

export const ReleaseDeployTickets: React.FC<Props> = React.memo(({ releaseId }) => {
   const selectOptions: SelectDeployTicketOptions = useMemo(() => ({ releaseId }), [releaseId]);
   const requestOptions: GetDeployTicketsReqOptions = useMemo(() => ({ releaseId }), [releaseId]);
   const defaultFilters: Partial<DeployTicketFilters> = useMemo(() => ({ releaseId }), [releaseId]);
   return (
      <DeployTicketsBlock
         pageType={DeployTicketPageType.release}
         selectOptions={selectOptions}
         requestOptions={requestOptions}
         defaultFilters={defaultFilters}
         excludeColumns={excludeColumns}
         emptyBlock={
            <EmptyContainer
               type={EmptyContainerType.EmptyState}
               title={`There are not deploy tickets for release ${releaseId}`}
            />
         }
      />
   );
});

ReleaseDeployTickets.displayName = 'ReleaseDeployTickets';
