import { EmptyContainer, EmptyContainerType } from '@yandex-infracloud-ui/libs';
import React from 'react';

import Page from '../../../../../old-code/components/Page/Page';
import PageWrapper from '../../../../../old-code/components/PageWrapper/PageWrapper';

import classes from './ReleaseNotFound.module.css';

interface Props {
   releaseId: string;
}

export const ReleaseNotFound: React.FC<Props> = ({ releaseId }) => (
   <PageWrapper title={`Release: ${releaseId} not found`}>
      <Page>
         <EmptyContainer
            className={classes.fullHeight}
            type={EmptyContainerType.NotFound}
            title={`Release ${releaseId} was not found`}
         />
      </Page>
   </PageWrapper>
);

ReleaseNotFound.displayName = 'ReleaseNotFound';
