import { AppRouteProps } from '../../../models';

import { StageBalancersPage } from './balancers/StageBalancersPage';
import { StageConfigPage } from './config/StageConfigPage';
import { StageDeployTicketsRoutes } from './deploy-tickets/_layout';
import { StageEditPage } from './edit/StageEditPage';
import { StageHistoryPage } from './history';
import { StageJsonPage } from './json/StageJsonPage';
import { StageLogsPage } from './logs/StageLogsPage';
import { StageMonitoringRoutes } from './monitoring/_layout';
import { ReleaseRuleRoutes } from './release_rules';
import { StageStatusPage } from './status/StageStatusPage';
import { StageUpdatePage } from './update/StageUpdatePage';
import { StageYamlPage } from './yaml/StageYamlPage';

export const ROUTES: AppRouteProps[] = [
   { path: '/balancers', component: StageBalancersPage },
   { path: '/config', component: StageConfigPage },
   { path: '/edit', component: StageEditPage },
   { path: '/history', component: StageHistoryPage },
   { path: '/update', component: StageUpdatePage },
   { path: '/json', component: StageJsonPage },
   { path: '/logs2', component: StageLogsPage, exact: true },
   { path: '/logs', component: StageLogsPage, exact: true },
   { path: '/yaml', component: StageYamlPage },
   { path: '/monitoring', component: StageMonitoringRoutes },
   { path: '/release_rules', component: ReleaseRuleRoutes },
   { path: '/deploy-tickets', component: StageDeployTicketsRoutes },
   { path: ['/status/:deployUnitId/:clusterId', '/status/:deployUnitId'], component: StageStatusPage },
   { path: '', component: StageStatusPage },
];
