import { useTitle } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { RouteComponentProps } from 'react-router';

import StageBalancers from '../../../../old-code/containers/StageBalancers/StageBalancers';
import { useStage } from '../../../../redux';

export const StageBalancersPage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(
   ({ location, match }) => {
      const { stageId } = match.params;

      useTitle(`Balancers / ${stageId}`);

      const { stage } = useStage(stageId);

      if (!stage) {
         return null;
      }

      const account_id = stage.project?.accountId ?? '';
      const abcServiceId = account_id === 'tmp' ? '' : account_id.split(':').pop();

      return <StageBalancers id={stageId} abcServiceId={abcServiceId} />;
   },
);

StageBalancersPage.displayName = 'StageBalancersPage';
