import { faEllipsisH, faTimesCircle } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button, Popover } from '@yandex-cloud/uikit';
import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import { useStagePermissions } from '../../../../../redux';

import classes from './RemoveStageButton.module.css';
import { RemoveStageConfirmModal } from './RemoveStageConfirmModal';

interface Props {
   projectId: string;
   stageId: string;

   onSuccess(): void;
}

export const RemoveStageButton: React.FC<Props> = React.memo(({ stageId, projectId, onSuccess }) => {
   const dismounted = useDismounted();

   const openConfirmation = useCallback(() => {
      modalService
         .open(RemoveStageConfirmModal, { stageId, projectId })
         .pipe(takeUntil(dismounted))
         .subscribe(
            () => {
               onSuccess();
            },
            () => null,
         );
   }, [dismounted, onSuccess, projectId, stageId]);

   const userStagePermissions = useStagePermissions(stageId);

   return userStagePermissions.delete ? (
      <span data-e2e={'StageActionsPopupButton'}>
         <Popover
            openOnHover={false}
            hasArrow={false}
            autoclosable={true}
            placement={'left'}
            content={
               <Button
                  className={classes.dangerButton}
                  onClick={openConfirmation}
                  extraProps={{ 'data-e2e': 'RemoveStageButton' }}
               >
                  <FontAwesomeIcon icon={faTimesCircle} /> Delete
               </Button>
            }
         >
            <Button view={'flat'}>
               <FontAwesomeIcon icon={faEllipsisH} />
            </Button>
         </Popover>
      </span>
   ) : null;
});

RemoveStageButton.displayName = 'RemoveStageButton';
