import React from 'react';

import { urlBuilder } from '../../../../../models';
import { Breadcrumbs } from '../../../../../old-code/components/Breadcrumbs/Breadcrumbs';

interface Props {
   stageId?: string;
   projectId?: string;
   lastPart?: string;
}

export const StageBreadcrumbs: React.FC<Props> = React.memo(({ projectId, stageId, lastPart }) => (
   <Breadcrumbs
      links={[
         { name: 'All', url: urlBuilder.home() },
         projectId ? { name: projectId, url: urlBuilder.project(projectId) } : undefined,
         stageId ? { name: stageId, url: urlBuilder.stage(stageId) } : undefined,
         lastPart ? { name: lastPart } : undefined,
      ]}
   />
));

StageBreadcrumbs.displayName = 'StageBreadcrumbs';
