import { EmptyContainer, EmptyContainerType } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { urlBuilder } from '../../../../../models';
import Page from '../../../../../old-code/components/Page/Page';
import PageWrapper from '../../../../../old-code/components/PageWrapper/PageWrapper';

import classes from './StageNotFound.module.css';

interface Props {
   stageId: string;
}

export const StageNotFound: React.FC<Props> = ({ stageId }) => (
   <PageWrapper title={`Stage: ${stageId} not found`}>
      <Page>
         <EmptyContainer
            className={classes.fullHeight}
            type={EmptyContainerType.NotFound}
            title={`Stage ${stageId} was not found`}
            description={'You can try to create it.'}
            action={{ text: 'Launch new Stage', link: urlBuilder.newStage() }}
         />
      </Page>
   </PageWrapper>
);

StageNotFound.displayName = 'StageNotFound';
