import React from 'react';

import { faStethoscope } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Label } from '@yandex-cloud/uikit';

import { useXRayStatus } from '../../../../../../../redux/hooks/useXRayStatus';
import { StageProblemTypeByXray } from '../../../../../../../models/ui/stage/XRay';
import { useStageProblems } from '../../../../../../../redux';
import {
   getIssueSummaryFromList,
   IssueLevelColors,
   labelThemeByLevel,
   SummaryLevel,
   summaryLevels,
} from '../../../../../../../modules/infra-doctor';

import classes from './StageProblemsLabel.module.css';

interface Props {
   stageId: string;
}

export const StageProblemsLabel: React.FC<Props> = React.memo(({ stageId }) => {
   const { xRayStatus } = useXRayStatus(stageId);
   const xraySummaryLevel = StageProblemTypeByXray[xRayStatus.summaryType];

   const { issues, isLoading } = useStageProblems(stageId);
   const { summary: problemSummary } = getIssueSummaryFromList({ issues });
   const doctorSummaryLevel = isLoading ? 'unknown' : problemSummary.summaryLevel;

   const summaryLevel: SummaryLevel =
      summaryLevels.find(l => l === xraySummaryLevel || l === doctorSummaryLevel) ?? 'unknown';

   return (
      <Label size={'m'} theme={labelThemeByLevel[summaryLevel]} className={classes.doctor}>
         <span style={{ color: IssueLevelColors[summaryLevel] }}>
            <FontAwesomeIcon icon={faStethoscope} />
         </span>
      </Label>
   );
});
