import React, { ReactNode, useMemo } from 'react';

import { urlBuilder } from '../../../../../models';
import NavigationTabs from '../../../../../old-code/components/NavigationTabs/NavigationTabs';

interface NavigationTab {
   path: string | { url: string; match: { predicate: string; strict?: boolean }[] };
   id: string;
   title: string;
   titleMark?: ReactNode;
}

interface Props {
   stageId: string;
}

export const StageTabs: React.FC<Props> = React.memo(({ stageId }) => {
   const tabs: NavigationTab[] = useMemo(
      () => [
         {
            path: {
               url: urlBuilder.stageStatus(stageId),
               match: [{ predicate: urlBuilder.stageStatus(stageId), strict: true }, { predicate: '/status' }],
            },
            id: 'status',
            title: 'Status',
         },
         {
            path: {
               url: urlBuilder.stageConfig(stageId),
               match: [{ predicate: urlBuilder.stageConfig(stageId) }, { predicate: urlBuilder.stageEdit(stageId) }],
            },
            id: 'config',
            title: 'Config',
         },
         {
            path: {
               url: urlBuilder.stageLogs(stageId),
               match: [{ predicate: urlBuilder.stageLogs(stageId), strict: true }],
            },
            id: 'logs',
            title: 'Logs',
         },
         { path: urlBuilder.stageMonitoring(stageId), id: 'monitoring', title: 'Monitoring' },
         { path: urlBuilder.stageHistory(stageId), id: 'history', title: 'History' },
         {
            path: {
               url: urlBuilder.stageDeployTickets(stageId),
               match: [{ predicate: urlBuilder.stageDeployTickets(stageId) }, { predicate: '/release_rules' }],
            },
            id: 'deploy-tickets',
            title: 'Deploy tickets',
         },
         { path: urlBuilder.stageBalancers(stageId), id: 'balancers', title: 'Balancers' },
      ],
      [stageId],
   );

   return <NavigationTabs tabs={tabs} />;
});

StageTabs.displayName = 'StageTabs';
