import React, { useCallback } from 'react';
import { Button, ButtonView } from '@yandex-cloud/uikit';
import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import { takeUntil } from 'rxjs/operators';

import { StageTurnClusterConfirmModal } from './StageTurnClusterConfirmModal';
import { StageClusterAction, stageClusterActionTitles } from './model';

interface Props {
   stageId: string;
   cluster: string;
   action: StageClusterAction;
}

const buttonView: Record<StageClusterAction, ButtonView> = {
   disable: 'action',
   enable: 'flat-info',
};

export const StageTurnClusterButton: React.FC<Props> = React.memo(({ stageId, cluster, action }) => {
   const dismounted = useDismounted();
   const onToggleClusterClick = useCallback(() => {
      modalService
         .open(StageTurnClusterConfirmModal, { action, cluster, stageId })
         .pipe(takeUntil(dismounted))
         .subscribe();
   }, [action, cluster, dismounted, stageId]);

   return (
      <Button view={buttonView[action]} onClick={onToggleClusterClick}>
         {stageClusterActionTitles[action]} {cluster.toUpperCase()}
      </Button>
   );
});

StageTurnClusterButton.displayName = 'StageTurnClusterButton';
