import { ButtonLink, useTitle } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';
import { RouteComponentProps } from 'react-router';

import { EditSharedNode } from '../../../../components/lib';
import { StageHugeForm } from '../../../../components/stage-huge-form';
import { StageHugeFormMode } from '../../../../components/stage-huge-form/models';
import { RenderArgs } from '../../../../components/stage-huge-form/StageHugeForm';
import { urlBuilder } from '../../../../models';
import { useFormStage, useStagePermissions } from '../../../../redux';

export const StageConfigPage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(({ location, match }) => {
   const { stageId } = match.params;
   const { rawStage } = useFormStage(StageHugeFormMode.View, stageId);
   const userHasAccessToEdit = useStagePermissions(stageId);

   useTitle(`Config / ${stageId}`);

   const internalUrl = location.pathname.slice(match.url.length);
   const formTabHash = location.hash ?? ''; // для поддержки FormTabs

   const renderChildren = useCallback(
      ({ content, contentEditViewSwitcher }: RenderArgs) => (
         <>
            <EditSharedNode>
               {contentEditViewSwitcher}

               {userHasAccessToEdit.edit && (
                  <ButtonLink
                     to={urlBuilder.stageEdit(stageId) + internalUrl + formTabHash}
                     data-e2e={'EditStageButton'}
                  >
                     Edit
                  </ButtonLink>
               )}
            </EditSharedNode>
            {content}
         </>
      ),
      [formTabHash, internalUrl, stageId, userHasAccessToEdit.edit],
   );

   if (!rawStage) {
      return null;
   }

   return (
      <div data-test={'StageConfigPage'}>
         <StageHugeForm mode={StageHugeFormMode.View} rawStage={rawStage}>
            {renderChildren}
         </StageHugeForm>
      </div>
   );
});

StageConfigPage.displayName = 'StageConfigPage';
