import React from 'react';

import { EmptyContainer, EmptyContainerType } from '@yandex-infracloud-ui/libs';

import { DiffView } from '../../../../../../components/lib';
import { TDeployTicketSpec_EDeployTicketSourceType } from '../../../../../../proto-typings';
import { useDeployTicket, useDraft, useStage } from '../../../../../../redux';
import { toYaml } from '../../../../../../utils';

interface Props {
   ticketId: string;
}

export const DraftDeployTicketInfo: React.FC<Props> = React.memo(({ ticketId }) => {
   const { deployTicket } = useDeployTicket(ticketId);

   const stageId = deployTicket?.stageId;
   const draftId = deployTicket?.stageDraftId;

   const { rawDraft } = useDraft(draftId ?? '');
   const { rawStage } = useStage(stageId ?? '');

   if (!deployTicket) {
      return null;
   }

   const isDraftTicket = deployTicket.sourceType === TDeployTicketSpec_EDeployTicketSourceType.STAGE_DRAFT;

   if (!isDraftTicket) {
      return null;
   }

   // TODO: поменять на честную мету
   if (!rawDraft) {
      return <EmptyContainer type={EmptyContainerType.NotFound} title={`Draft ${draftId} not found`} />;
   }

   const getSpecText = (spec: any) => spec && toYaml(spec);
   const stageSpecText = getSpecText(rawStage?.spec);
   const draftSpecText = getSpecText(rawDraft?.spec?.stage_spec);

   return (
      <DiffView
         fullContext={false}
         language={'yaml'}
         modified={draftSpecText}
         original={stageSpecText}
         unified={false}
      />
   );
});

DraftDeployTicketInfo.displayName = 'DraftDeployTicketInfo';
