import { EmptyContainer, EmptyContainerType } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { TDeployTicketSpec_EDeployTicketSourceType } from '../../../../../../proto-typings';
import { useDeployTicket, useRelease } from '../../../../../../redux';
import { DockerResources, SandboxResources } from '../../../../../../components/release';

interface Props {
   ticketId: string;
}

export const ReleaseDeployTicketInfo: React.FC<Props> = React.memo(({ ticketId }) => {
   const { deployTicket } = useDeployTicket(ticketId);

   const releaseId = deployTicket?.releaseId;

   const { release, meta } = useRelease(releaseId ?? '');

   if (!deployTicket) {
      return null;
   }

   const isReleaseTicket = deployTicket.sourceType === TDeployTicketSpec_EDeployTicketSourceType.RELEASE_INTEGRATION;

   if (!isReleaseTicket) {
      return null;
   }

   if (meta.isNotFound) {
      return <EmptyContainer type={EmptyContainerType.NotFound} title={`Draft ${releaseId} not found`} />;
   }

   if (!release) {
      return null;
   }

   return (
      <div>
         <h3>Release {releaseId}</h3>
         Resources ({release.type}){release.sandbox && <SandboxResources sandbox={release.sandbox} />}
         {release.docker && <DockerResources docker={release.docker} />}
         {
            // TODO Dynamic resources
         }
      </div>
   );
});

ReleaseDeployTicketInfo.displayName = 'ReleaseDeployTicketInfo';
