import { faArrowLeft } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import React, { ReactNode } from 'react';
import { Link, RouteComponentProps } from 'react-router-dom';

import { urlBuilder } from '../../../../../models';
import ContainerLoader from '../../../../../old-code/components/ContainerLoader/ContainerLoader';
import { TDeployTicketSpec_EDeployTicketSourceType } from '../../../../../proto-typings';

import { useDeployTicket } from '../../../../../redux';
import { DraftDeployTicketInfo } from './components/DraftDeployTicketInfo';
import { ReleaseDeployTicketInfo } from './components/ReleaseDeployTicketInfo';
import { DeployTicketItem } from '../../../../../components/deployTicket';
import { Page } from '../../../../../components/layout/Page/Page';

interface RouteParams {
   stageId: string;
   ticketId: string;
}

const classes = {} as Record<string, string>;

export const DeployTicketPage: React.FC<RouteComponentProps<RouteParams>> = React.memo(({ match }) => {
   const { stageId, ticketId } = match.params;
   const { deployTicket, meta } = useDeployTicket(ticketId);

   if (!deployTicket) {
      return meta.isProcessing ? <ContainerLoader /> : null;
   }

   // info более детальная информация о тикете в зависимости от его типа
   let info: ReactNode = null;
   switch (deployTicket.sourceType) {
      case TDeployTicketSpec_EDeployTicketSourceType.STAGE_DRAFT: {
         info = <DraftDeployTicketInfo ticketId={ticketId} />;
         break;
      }
      case TDeployTicketSpec_EDeployTicketSourceType.RELEASE_INTEGRATION: {
         info = <ReleaseDeployTicketInfo ticketId={ticketId} />;
         break;
      }
   }

   return (
      <div className={classes.page} data-e2e={'Ticket:Body'}>
         <Page header={null}>
            <Link to={urlBuilder.stageDeployTickets(stageId)}>
               <FontAwesomeIcon icon={faArrowLeft} /> Back to list of tickets
            </Link>
            <DeployTicketItem ticketId={ticketId} />
            {info}
         </Page>
      </div>
   );
   // end region
});

DeployTicketPage.displayName = 'DeployTicketPage';
