import { DISMISS_REASON, IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import { ApprovalPolicy } from '../approvalPolicy';

import classes from './ApprovalPolicyModal.module.css';

interface Props extends IModalProps<{}> {
   stageId: string;
   approvalVisible: boolean;
   bumpApprovalUpdateCount: () => void;
}

export const ApprovalPolicyModal: React.FC<Props> = React.memo(
   ({ cancel, stageId, approvalVisible, bumpApprovalUpdateCount }) => {
      const dismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);

      return (
         <div className={classes.approvalModal}>
            <ModalLayout
               title={`Approval settings`}
               showFooter={false}
               onDismiss={dismiss}
               data-e2e={'ApprovalPolicy:Modal'}
            >
               <div>
                  <p>Approval policy for stage {stageId}</p>
                  <ApprovalPolicy
                     stageId={stageId}
                     approvalVisible={approvalVisible}
                     bumpApprovalUpdateCount={bumpApprovalUpdateCount}
                  />
               </div>
            </ModalLayout>
         </div>
      );
   },
);

ApprovalPolicyModal.displayName = 'ApprovalPolicyModal';
