import { faUserCog } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button } from '@yandex-cloud/uikit';
import { DISMISS_REASON, modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useState } from 'react';
import { takeUntil } from 'rxjs/operators';
import { noop } from '../../../../../../utils';
import { ApprovalPolicyModal } from '../ApprovalPolicyModal/ApprovalPolicyModal';

interface Props {
   stageId: string;
}

export const ApprovalPolicyTooltip: React.FC<Props> = React.memo(({ stageId }) => {
   // для ререндера при обновлении политики апрувов
   const [, setApprovalUpdateCount] = useState(0);

   const dismounted = useDismounted();

   const openModal = useCallback(() => {
      // setApprovalVisible(true);
      modalService
         .open(ApprovalPolicyModal, {
            stageId,
            approvalVisible: true,
            bumpApprovalUpdateCount: () => setApprovalUpdateCount(count => count + 1),
         })

         .pipe(takeUntil(dismounted))
         .subscribe(noop, reason => {
            if (reason !== DISMISS_REASON) {
               console.error(reason);
            }
         });
   }, [dismounted, stageId]);

   return (
      <div data-e2e={'ApprovalPolicy:Tooltip'}>
         <Button view={'normal'} onClick={openModal}>
            <FontAwesomeIcon icon={faUserCog} /> Approval Policy
         </Button>
      </div>
   );
});

ApprovalPolicyTooltip.displayName = 'ApprovalPolicyTooltip';
