import { EmptyContainer, EmptyContainerType } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { useStage } from '../../../../../../redux';

export const DeployTicketsEmptyContainer: React.FC<{ stageId: string }> = React.memo(({ stageId }) => {
   const { stage } = useStage(stageId);

   if (!stage) {
      return null;
   }

   const canAddSandboxRule = stage.sandboxTargets.length > 0;
   const canAddDockerRule = stage.dockerTargets.length > 0;

   return (
      <EmptyContainer
         type={EmptyContainerType.EmptyState}
         title={`There are no deploy tickets for stage ${stageId}`}
         description={
            <>
               Let’s create a new release rule or a new draft.
               {!canAddDockerRule && !canAddSandboxRule ? (
                  <p>Can't create release rule. Please edit stage to add Docker or Sandbox resources.</p>
               ) : null}
            </>
         }
      />
   );
});

DeployTicketsEmptyContainer.displayName = 'DeployTicketsEmptyContainer';
