import { plural } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { ReleaseRule, ReleaseRuleType } from '../../../../../../models/ui/releases';
import classes from './ResourceWarning.module.css';

interface Props {
   rule: ReleaseRule;
}

export const ResourceWarning: React.FC<Props> = React.memo(({ rule }) => {
   if (!rule.form) {
      return null;
   }

   if (rule.form.type === ReleaseRuleType.Sandbox) {
      const { patches } = rule.form.sandbox!;
      if (patches.length === 0) {
         return null;
      }

      return (
         <>
            <p>Tickets for the next {plural(patches.length, 'resource', 'resources')} won’t be created anymore:</p>

            <ul className={classes.list}>
               {patches.map(p => (
                  <li key={p.id}>
                     <b>{p.ref}</b> ({p.deployUnitId})
                  </li>
               ))}
            </ul>
         </>
      );
   }

   if (rule.form.type === ReleaseRuleType.Docker) {
      const { patches } = rule.form.docker!;
      if (patches.length === 0) {
         return null;
      }

      return (
         <>
            <p>Tickets for the next {plural(patches.length, 'box', 'boxes')} won’t be created anymore:</p>

            <ul className={classes.list}>
               {patches.map(p => (
                  <li key={p.id}>
                     <b>{p.boxId}</b> ({p.deployUnitId})
                  </li>
               ))}
            </ul>
         </>
      );
   }

   return null;
});

ResourceWarning.displayName = 'ResourceWarning';
